<!DOCTYPE html>
<html>
<head>
    <title>Order Status Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f9f9f9;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .header {
            background: #4CAF50;
            color: #fff;
            padding: 10px 20px;
            text-align: center;
            border-radius: 5px 5px 0 0;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 12px;
            color: #888;
        }
        .button {
            display: inline-block;
            background: #4CAF50;
            color: #fff;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Order Notification</h1>
        </div>
        <p>Hello {{ $order_details->orderDetail->first_name.' '.$order_details->orderDetail->last_name }},</p>
        <p>Thank you for shopping with us! Here is the current status of your order:</p>
        <ul>
            <li><strong>Order ID:</strong> {{ $order_details->id }}</li>
            <li><strong>Status:</strong> {{ $order_details->status }}</li>
            <li><strong>Placed on:</strong> {{ $order_details->created_at->format('F j, Y') }}</li>
        </ul>
        @if ($order_details->status == 'sent')
            <p><strong>Tracking Link:</strong> <a href="{{ $order_details->tracking_link }}">{{ $order_details->tracking_link }}</a></p>
            
        @endif
        <p>If you have any questions, feel free to <a href="{{ url('/contact-us') }}" class="button">Contact Us</a>.</p>
        <div class="footer">
            <p>&copy; {{ date('Y') }} Your Lovecans. All Rights Reserved.</p>
        </div>
    </div>
</body>
</html>
