@extends('layouts.admin')

@section('content')
    
    <div class="users p-5">
        <h4 class="border-bottom border-3">User Verification Files</h4>
        
        @foreach ($verifications as $userId => $userFiles)
            <div class="user-container">
                {{-- user Details --}}
                <div class="d-flex align-items-center  border-bottom border-2 py-2 my-2 px-0">
                    <img class="mx-3" src="{{asset('storage/avatars/'.$userFiles[0]->profile_picture)}}" alt="" style="width:70px;height:70px;border-radius:50px">
                    <h3 class="ml-3">{{ $userFiles[0]->name }}</h3>
                </div>
                
                <div class="verification-items container">
                    
                    <div class="row px-0">
                        @foreach ($userFiles as $file)
                            @php
                                $file_type = explode('/',$file->file_path);
                                $file_type = $file_type[0];
                            @endphp 
                                <div class="col-4 rounded border m-1 float-start" style="max-height:200px">
                                    @if ($file_type === 'images')
                                        <img src="{{ asset('storage/' . $file->file_path) }}" alt="Verification Image" style="width:100%;height:100%;object-fit:contain">
                                    @elseif ($file_type === 'videos')
                                        <video controls style="width:100%;height:100%;object-fit:cover">
                                            <source src="{{ asset('storage/' . $file->file_path) }}" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                    @endif
                                </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="d-flex  justify-content-end">
                <form action="{{route('admin.update-seller-status',$userFiles[0]->profile_id)}}" method="POST" style="width: fit-content" class=" text-end">
                    @csrf
                    <input type="hidden" name="status" value="verified">
                    <input type="submit" name="" id="" value="Verify" class="form-control btn btn-primary mt-3" style="width:150px">
                </form>
                <form action="{{route('admin.update-seller-status',$userFiles[0]->profile_id)}}" method="POST" style="width: fit-content" class="mx-1 text-end">
                    @csrf
                    <input type="hidden" name="status" value="blocked">
                    <input type="submit" name="" id="" value="Block" class="form-control btn btn-danger mt-3" style="width:150px">
                </form>
            </div>
            <hr>
        @endforeach
    </div>
@endsection