@extends('layouts.admin')

@section('content')
    <div class="container">

        <div class="d-flex justify-content-between align-items-center mb-4 pt-5">
            <h1 class="lead">Update Ad Promotion</h1>
            <a href="{{ route('admin.settings') }}" class="btn btn-primary">back</a>
        </div>


            @session('success')
                <p class="alert alert-success" role="alert">
                    {{ session('success') }}
                </p>
            @endsession

            @session('error')
                <p class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </p>
            @endsession
           
            <form action="{{ route('admin.settings.update', $settings->id) }}" method="POST">
                @csrf
                
                <div class="col-12 mb-2 form-group">
                    <label for="promotion_fee">Promotion Fee</label>
                    <input type="number" name="promotion_fee" class="form-control" value="{{ $settings->promotion_fee ?? '' }}" required>
                </div>

                <div class="col-12 mb-2 form-group">
                    <label for="promotion_duration">Promotion Duration (Days)</label>
                    <input type="number" name="promotion_duration" class="form-control" value="{{ $settings->promotion_duration ?? '' }}" required>
                </div>

                <div class="col-12 mb-2 form-group">
                    <label for="description">Description</label>
                    <textarea name="description" id="description" class="form-control">{{ $settings->description ?? '' }}</textarea>
                </div>

                
                <button type="submit" class="btn btn-success mt-3">Update Promotion</button>

            </form>
        
    </div>
@endsection
