@extends('layouts.admin')

@section('content')
    <style>

        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Seller Report</h3>

                    {{-- <form method="GET" action="{{ route('admin.settings') }}">
                        <div class="input-group mb-3">
                            <input
                                type="text"
                                name="search"
                                class="form-control"
                                placeholder="Search ......"
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.settings') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form> --}}

                    @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif

                <div class="table-responsive">
                    <table class="table table-striped table-responsive">
                        <thead>
                            <tr>
                                <th>Sr.No</th>
                                <th>subject</th>
                                <th>message</th>
                                <th>Seller Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($messages as $message)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $message->subject }}</td>
                                    <td>{{ $message->message }}</td>
                                    <td>{{ $message->user->name }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4">
                                        <p class="text-center">No messages found...</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                     {!! $messages->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>

            </div>
        </div>
    </div>

@endsection





