@extends('layouts.admin')

@section('content')
    <style>

        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                @session('success')
                    <p class="col-12 alert alert-success" role="alert">
                        {{session('success')}}
                    </p>
                @endsession

                @session('error')
                    <p class="col-12 alert alert-danger" role="alert">
                        {{session('error')}}
                    </p>
                @endsession
                <div class="col-lg-12 mt-3">
                  <div class="d-flex justify-content-between align-items-center">
                    <h3>All subCategories</h3>
                    <a href="{{ route('admin.sub-categories.create') }}" class="btn btn-primary">add</a>
                  </div>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Sub Category</th>
                                    <th>Images</th>
                                    <th>description</th>
                                    <th>Category</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($subCategories as $category)
                                <tr class="align-content-center">
                                    <td>{{$loop->iteration}}</td>
                                    <td>
                                        {{$category->title}}
                                    </td>
                                    <td>

                                        <img src="{{ asset($category->images) }}" alt="Subcategory Image" class="img-fluid">

                                    </td>
                                    <td>
                                        {{$category->description}}
                                    </td>
                                    <td>
                                        {{$category->category->category}}
                                    </td>
                                    <td>

                                        <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal"
                                        data-url="{{ route('admin.sub-categories.delete', $category->id) }}">
                                    <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                                </button>
                                        <a href="{{ route('admin.sub-categories.edit', $category->id) }}">
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAThJREFUSEvl1b1KxEAUhuFnK7HSSgTBQgQt9AYsrO28A6/AUlErFWT97fQWbLW1F7wBsRNBEMRC0M5K3QNZiMlmmUS38kBIQma+d853zmRaBhytAev7S8AxXnCSX3QRsIwDzPbJ7BMrOM+NOcVq9r6ehxQBT5ioKT6GW8S9G1vZQksWfWUjUq0bxRumcY3xbP4GjuK5KFQHsIa4FjqWPWAKN9jDWTeVpoBN7Gciz1jEPUbw3q/IKRmEv+1CnQIyj9di/epmEJZEOxYjWjO6pxR1AKniS7iqW4MdbCesPMQvMVwHEMIBSLHlo1P8oXx3pljULXweUOV5qUmaACKb3Yrd/mvAj/9MD0gjQJ9fU+nTPwA8YrKOJz3G3mGuah/EgXOImYaQOBeiyy6qAA11q6elHiyNwQMHfAOdL0QZH51cjgAAAABJRU5ErkJggg=="/>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                                @if ($subCategories->count() == 0)
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No subCategories</p>
                                        </td>
                                    </tr>

                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                {!! $subCategories->links('pagination::bootstrap-5') !!}
            </div>
        </div>
    </div>



   <!-- Modal -->
   <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteModal = document.getElementById('deleteModal');
        const deleteForm = document.getElementById('deleteForm');

        deleteModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget; // Button that triggered the modal
            const url = button.getAttribute('data-url'); // Extract URL from data-url
            deleteForm.setAttribute('action', url); // Set form action dynamically
        });
    });
</script>

@endsection
