@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 m-3 row justify-content-center">
            @if(session('success'))
                <p class="alert alert-success" role="alert">
                    {{ session('success') }}
                </p>
            @endif

            @if(session('error'))
                <p class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </p>
            @endif

            <form action="{{ route('admin.sub-categories.update', $subCategory->id) }}" method="POST" class="p-4 card row col-md-6 justify-content-center" enctype="multipart/form-data">
                @csrf

                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">Edit Sub Category</h1>
                    <a href="{{ route('admin.sub-categories.index') }}" class="btn btn-primary">back</a>
                  </div>

                <div class="col-12 mb-2 form-group">
                    <label for="">Sub Category Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Category Title ..." value="{{ $subCategory->title }}">
                    @error('title')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>

                <div class="col-12 mb-2  form-group">
                    <label for="">Images</label>
                    <input type="file" name="images"  class="form-control">
                    <img src="{{ asset($subCategory->images) }}" alt="Subcategory Image" class="img-fluid">
                    @error('images')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>

                <div class="col-12 mb-2 form-group">
                    <label for="">Description</label>
                    <input type="text" name="description" class="form-control" placeholder="Category description ..." value="{{ $subCategory->description }}">
                    @error('description')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>

                <div class="col-12 mb-2 form-group">
                    <label for="">Category</label>
                    <select name="category_id" class="form-control">
                        <option value="">Select One</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ $subCategory->category_id == $category->id ? 'selected' : '' }}>
                                {{ $category->category }}
                            </option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>

                <div class="col-md-12 mb-3 d-flex form-group justify-content-center">
                    <button class="btn btn-primary w-100">Update</button>
                </div>
            </form>
        </div>
    </div>
@endsection
