@extends('layouts.admin')

@section('content')
    <div class="pt-3">

        <div class="ps-section__content p-4  m-3 row justify-content-center">
            @session('success')
                <p class="alert alert-success" role="alert">
                    {{session('success')}}
                </p>
            @endsession

            @session('error')
                <p class="alert alert-danger" role="alert">
                    {{session('error')}}
                </p>
            @endsession
            <form action="{{route('admin.sub-categories.store')}}" method="POST" class="p-4 card row col-md-6 justify-content-center" enctype="multipart/form-data">
                @csrf
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">   Add Sub Category</h1>
                    <a href="{{ route('admin.sub-categories.index') }}" class="btn btn-primary">back</a>
                  </div>
                <div class="col-12 mb-2  form-group">
                    <label for="">Sub Category Title</label>
                    <input type="text" name="title"  class="form-control" placeholder="Category Title ...">
                    @error('title')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>

                <div class="col-12 mb-2  form-group">
                    <label for="">Images</label>
                    <input type="file" name="images"  class="form-control">
                    @error('images')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>


                <div class="col-12 mb-2  form-group">
                    <label for="">Description</label>
                    <input type="text" name="description"  class="form-control" placeholder="Category description ...">
                    @error('description')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>

                <div class="col-12 mb-2  form-group">
                    <label for="">Category</label>
                    <select name="category_id" id="" class="form-control">
                        <option value="select one">Select One</option>
                        @foreach($categories as $category)
                        <option value="{{ $category->id }}">{{ $category->category }}</option>
                    @endforeach
                    </select>
                    @error('category_id')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-12 mb-3 d-flex form-group justify-content-center">
                    <button class="btn btn-primary w-100">Create</button>
                </div>
            </form>
        </div>
    </div>


@endsection
