@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 card m-3">
            <form action="" method="" class="row">
                @csrf
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">Seller Activity Log Details</h1>
                    <a href="{{ route('admin.seller-activity-log') }}" class="btn btn-primary">Back</a>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Seller Name</label>
                    <input type="text" value="{{ $sellerrecprds->seller->name }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Seller Email</label>
                    <input type="text" value="{{ $sellerrecprds->seller->email }}" class="form-control" disabled>
                </div>

                <div class="col-md-6 mb-3 form-group">
                    <label for="">Latest Action Details</label>
                    <textarea class="form-control" disabled>{{ optional($sellerrecprds->seller->activityLogs->last())->details ?? 'No details available' }}</textarea>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Latest Action</label>
                    <input type="text" value="{{ optional($sellerrecprds->seller->activityLogs->last())->action ?? 'No action available' }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Address</label>
                    <input type="text" value="{{ optional($sellerrecprds->seller->profile)->address ?? 'No address available' }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">IP Address</label>
                    <input type="text" value="{{ $sellerrecprds->ip_address }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Location</label>
                    <input type="text" value="{{ $sellerrecprds->location }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Browser Details</label>
                    <input type="text" value="{{ $sellerrecprds->browser_details }}" class="form-control" disabled>
                </div>
            
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Activity Time</label>
                    <input type="text" value="{{ $sellerrecprds->activity_time }}" class="form-control" disabled>
                </div>
            </form>
            
        </div>    
    </div>
    
@endsection