@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 card m-3">
            <form action="" method=""  class="row">
                @csrf
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">
                        Seller Details 
                    </h1>
                    <a href="{{ route('admin.seller_profiles') }}" class="btn btn-primary">back</a>
                </div>
                @forelse ($sellers as $seller)
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Name</label>
                    <input type="text" value="{{$seller->name}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Nickname</label>
                    <input type="text" value="{{$seller->nickname}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Description</label>
                    <input type="text" value="{{$seller->description}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Email</label>
                    <input type="text" value="{{$seller->email}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Age</label>
                    <input type="number" value="{{$seller->age}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Figure</label>
                    <input type="test" value="{{$seller->figure}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Type</label>
                    <input type="test" value="{{$seller->type}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Eye color</label>
                    <input type="test" value="{{$seller->eye_color}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Hair Color</label>
                    <input type="test" value="{{$seller->hair_color}}" class="form-control" disabled>
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Address</label>
                    <input type="text" value="{{$seller->address}}" class="form-control" disabled>
                </div>
                @empty
                <div class="col-12">
                    <div class="alert alert-warning text-center">
                        No sellers found.
                    </div>
                </div>
                @endforelse
            </form>
        </div>    
    </div>


@endsection