@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Seller ActivityLogs</h3>
                    
                    <form method="GET" action="{{ route('admin.showUserActivityLog') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search ......" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.showUserActivityLog') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>User Name</th>
                                    <th>Actions</th>
                                    <th>Details</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $i = 0;
                                @endphp
                                @forelse ($activityLogs as $activityLog)
                                <tr>
                                    <td>{{ ++$i }}</td>
                                    <td>{{ $activityLog->user->name }}</td>
                                    <td>{{ $activityLog->action }}</td>
                                    <td>{{ $activityLog->details }}</td>
                                    <td>
                                        <form action="{{ route('admin.clearActivityLog', $activityLog->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure? Type DELETE to confirm.');">
                                                Clear Log
                                            </button>
                                        </form>
                                        
                                    </td>
                                </tr>
                                @empty
                                    <td class="text-center text-capitalize">no activity logs</td>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                     {!! $activityLogs->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>
               
            </div>
        </div>    
    </div>
@endsection