@extends('layouts.admin')

@section('content')
    {{-- Messages --}}
    <br>
    <div class="card mx-md-3">

        <div class="row justify-content-center p-3">
           
            <div class="col-md-11">
                @session('success')
                    <p class="alert alert-success" role="alert">
                        {{ session('success') }}
                    </p>
                @endsession
                <div>
                    <a href="{{route('admin.seller_profiles')}}" class="btn btn-primary text-dark">
                       <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAMNJREFUSEvtlDEKwkAQRV8OIWiv4BlE8BaCteB1xFrwMArewcZe8BD6wYUtss5Mku2SMizv/fnZSUPlp6nMZxSYDUcqmgI74GhSswNegeBXYAEcgLNX4hEIfgPmwBNYAa+hBDn8AWwicIX4N8EEuP+SC74G3t7k6VxJILg6X34/bGd4aYIcHgncGrbtZXWBUletKNUyiMTag943yRJoml674BEkSfpV7IGL93p5BeLNgC1w8sKtTY5wimcjE3QSjgKztg/ExiAZuzHo1gAAAABJRU5ErkJggg=="/> Back
                    </a>
                </div>  
                <div class="my-2">
                    <strong>
                        Messages
                    </strong>
                </div>
                <div class="ps-section__right">
                    <div class="ps-section__content">
                        @foreach ($messages as $message)
                        <div class="row mt-3 justify-content-between border border-1 p-2 align-items-center" style="border-radius: 10px">
                            <div class="col-2 text-start">
                                {{-- <img src="https://www.shutterstock.com/image-vector/vector-flat-illustration-grayscale-avatar-600nw-2264922221.jpg" alt="" style="width:50px;height:50px;"> --}}
                                <div>
                                    {{-- <b>AZ Solutions</b> --}}
                                    <b>{{$message->user->name}}</b>
                                </div>
                            </div>
                            <div class="col-7 ">
                                {{-- <b>Message Subject</b> --}}
                                <b>{{$message->subject}}</b>
                                <p class="p-0 m-0">
                                    {{$message->message}}
                                    {{-- Lorem ipsum dolor sit, amet consectetur adipisicing elit. Fuga, expedita! --}}
                                    {{-- Lorem ipsum dolor sit, amet consectetur adipisicing elit. Fuga, expedita! --}}
                                </p>
                            </div>
                            <div class="col-3 d-flex justify-content-end">
                                <div>
                                    {{-- <span>18-10-1999</span> --}}
                                    <span>{{$message->created_at->format('H:i:s A d-M-Y')}}</span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        <div class="mt-3">
                            {!! $messages->withQueryString()->links('pagination::bootstrap-5') !!}  
                        </div>
                        <hr>
                    </div>

                    <form action="{{route('admin.send-message',$user_id)}}" method="POST">
                        @csrf
                        <h3 class="lead  border-start border-4 px-2"> 
                            Send Messages
                        </h3>
                        <div class="form-group my-3">
                            <input type="text" name="subject" placeholder="Subject..." class="form-control" required>
                            @error('subject')
                                <p class="text-danger">
                                    {{$message}}
                                </p>
                            @enderror
                        </div>
                        <div class="form-group">
                            <textarea name="message" id="" cols="30" rows="5" class="form-control" placeholder="Message ...." required></textarea>
                            @error('message')
                                <p class="text-danger">
                                    {{$message}}
                                </p>
                            @enderror
                        </div>
                        <div class="d-flex justify-content-end mt-3">
                            <input type="submit" value="Send" class="btn btn-primary">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    
    </div>
@endsection    