@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>

    
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>Seller Product Offers</h3>
                    <form method="GET" action="{{ route('admin.seller-offers') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.seller-offers') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped" >
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Price</th>
                                    <th>Received</th>
                                    <th>Delivery Status</th>
                                    <th>Payment Status</th>
                                    <th>View</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $item)
                                <tr class="align-content-center">
                                    <td>{{$loop->iteration}}</td>
                                    <td>
                                        <a href="{{asset('storage/ads/'.$item->image)}}" target="_blank">
                                        <img src="{{asset('storage/ads/'.$item->image)}}" alt="" style="width: 50px;border-radius:50px">
                                        </a>
                                    </td>
                                    <td>{{$item->title}}</td>
                                    <td>${{$item->price}}</td>
                                    <td>
                                        @if ($item->is_received == 1)
                                            <p class="badge bg-success">Received</p>
                                        @else
                                            <p class="badge bg-danger">Not Received</p>
                                        @endif
                                    </td>
                                    
                                    <td>{{$item->offer_sent_status}}</td>
                                    <td>{{$item->payment_status?'Paid':'Unpaid'}}</td>
                                    <td>
                                        <a href="{{route('admin.seller-ad-view',$item->id)}}" class="btn btn-dark">
                                            View
                                        </a>
                                    </td>
                                    <td >
                                        <form action="{{route('admin.update-offer-status',$item->id)}}" class="d-flex flex-wrap mx-auto" style="width: fit-content" method="POST">
                                            @csrf
                                            <select name="offer_status" id="" class="form-control" style="width: fit-content">
                                                <option value="Accepted" {{$item->offer_status == 'Accepted' ? 'selected' : ''}}>Accept</option>
                                                <option value="Rejected" {{$item->offer_status == 'Rejected' ? 'selected' : ''}}>Decline</option>
                                            </select>
                                            <input type="submit" class="btn btn-primary mx-2" value="Update" {{$item->offer_status == 'Accepted' ? 'disabled' : ''}}  style="width: fit-content">
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                                @if ($data->isEmpty())
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Product Offers ... !</p>                                        
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $data->withQueryString()->links('pagination::bootstrap-5') !!}  

                </div>
            </div>
        </div>    
    </div>
@endsection



