@extends("layouts.admin")

@section("content")
    <style>
        .product-image {
            max-height: 400px;
            object-fit: cover;
        }
        .btn-report {
            background-color: #f8d7da;
            color: #842029;
        }
        .btn-report:hover {
            background-color: #f5c2c7;
        }
    </style>
    
    <div class="container my-5 p-5">
        <div class="row m-auto shadow py-4">
            @session('success')
                <p class="col-12 alert alert-success" role="alert">
                    {{session('success')}}
                </p>
            @endsession

            
            @session('error')
                <p class="col-12 alert alert-danger" role="alert">
                    {{session('error')}}
                </p>
            @endsession
            <!-- Product Image -->
            <div class="col-md-6 text-center">
                <img src="{{asset('storage/ads/'.$sellerad->image)}}" alt="Product Image" class="img-fluid product-image rounded shadow w-100" style="object-fit: fill">
            </div>

            <!-- Product Details -->
            <div class="col-md-6">
                <h3 class="mb-3">{{$sellerad->title}}</h3>
                <p class="h4 text-success mb-3">${{$sellerad->price}}</p>
                <p> <b class="text-muted mb-3">Type : </b> {{$sellerad->type}}</p>
                <p> <b class="text-muted mb-3">Worn Days : </b> {{$sellerad->worn_days}}</p>
                
                <p class="mb-4">
                    <b class="text-muted mb-3">Description : </b>
                    {{$sellerad->description}}
                </p>
                <p> <b class="text-muted mb-3">Free Of Diseases : </b>  {{$sellerad->free_of_diseases?'Yes':'No'}}</p>
                <p> <b class="text-muted mb-3">Drug Free : </b> {{$sellerad->drugs_free?'Yes':'No'}}</p>
                <p><b class="text-muted mb-3">Delivery Status : </b> {{$sellerad->offer_sent_status}}</p>
                <p><b class="text-muted mb-3">Seller :</b> {{$sellerad->user->name}}</p>
                @if ($sellerad->offer_status === 'Accepted')
                    <div class="d-flex">
                        <form action="{{route('admin.receive-seller-ad', $sellerad->id)}}" method="GET">
                            <button class="btn btn-primary add-to-cart-btn" {{($sellerad->is_received)?'disabled':''}}>  {{($sellerad->is_received)?'Received':'Receive'}}</button>
                        </form>
                        <form action="{{route('admin.pay-seller-ad', $sellerad->id)}}" method="GET">
                            <button class="btn btn-success mx-2"  {{($sellerad->payment_status)?'disabled':''}}> {{($sellerad->payment_status )?'Paid':'Pay'}}</button>
                        </form>
                        @if ($sellerad->tracking_link)
                            <p>
                                <a href="{{$sellerad->tracking_link}}" class="btn btn-primary" target="_blank">Track Product</a>
                            </p> 
                        @endif
                    </div>
                @else
                    <form action="{{route('admin.update-offer-status',$sellerad->id)}}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-6">
                                <select name="offer_status" id="" class="form-control col-6" >
                                    <option value="Accepted" {{$sellerad->offer_status == 'Accepted' ? 'selected' : ''}}>Accept</option>
                                    <option value="Rejected" {{$sellerad->offer_status == 'Rejected' ? 'selected' : ''}}>Decline</option>
                                </select>
                           </div>
                            <div class="col-6">
                                <input type="submit" class="btn btn-primary" value="Update" {{$sellerad->offer_status == 'Accepted' ? 'disabled' : ''}}>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>  

@endsection