@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Released Payouts </h3>
                    @session('success')
                        <p class="col-12 alert alert-success" role="alert">
                            {{session('success')}}
                        </p>
                    @endsession
                    @session('error')
                        <p class="col-12 alert alert-danger" role="alert">
                            {{session('error')}}
                        </p>
                    @endsession
                    <form method="GET" action="{{ route('admin.seller-released-payout') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="seller ...." 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.seller-released-payout') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Seller Name</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($requests as $request)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $request->user->name }}</td>
                                        <td>${{ $request->amount }}</td>
                                        <td>{{ $request->created_at->format('d M Y h:i:s A') }}</td>
                                        <td>{{ $request->status }}</td>
                                        <td>
                                            <form action="{{route('payout.status-update', $request->id)}}" method="POST">
                                                @csrf
                                                <div class="row p-0">
                                                    <div class="col-6" style="min-width: fit-content">
                                                        <select name="status" id="" class="form-control"  style="width: fit-content">
                                                            <option value="pending" {{ ($request->status == 'pending')? 'selected' : '' }}>Pending</option>
                                                            <option value="rejected" {{ ($request->status == 'rejected')? 'selected' : '' }}>Reject</option>
                                                            <option value="released" {{ ($request->status == 'released')? 'selected' : '' }}>Release Amount</option>
                                                        </select>
                                                    </div>
                                                    <di v class="col-6" style="min-width: fit-content">
                                                        <input type="submit" value="Update" class="btn btn-primary w-100"  {{ ($request->status == 'released')? 'disabled' : '' }}>
                                                    </div>

                                                </div>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @if ($requests->count() === 0)
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Any Request . . . !</p>
                                        </td>                                    
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                     {!! $requests->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>
               
            </div>
        </div>    
    </div>
@endsection