@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>

    
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>All Products</h3>
                    <form method="GET" action="{{ route('admin.products') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.products') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Description</th>
                                    <th>Worn Days</th>
                                    <th>Price</th>
                                    <th>Payment Status</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($products as $item)
                                <tr class="align-content-center">
                                    <td>{{ ++$i }}</td>
                                    <td>
                                        <a href="{{ asset('storage/ads/' . $item->image) }}" target="_blank">
                                            <img src="{{ asset('storage/ads/' . $item->image) }}" alt="" style="width: 50px;border-radius:50px">
                                        </a>
                                    </td>
                                    <td>{{ $item->title }}</td>
                                    <td>{{ $item->type }}</td>
                                    <td>{{ \Illuminate\Support\Str::limit(strip_tags($item->description), 30, '...') }}</td>
                                    <td>{{ $item->worn_days }}</td>
                                    <td>${{ $item->price }}</td>
                                    <td>
                                        @if ($item->sellerpayment)
                                            <p class="payment-status {{ $item->sellerpayment->payment_status == 'Success' ? 'text-success' : ($item->sellerpayment->payment_status == 'Failed' ? 'text-danger' : 'text-success') }}">
                                                {{ $item->sellerpayment->payment_status }}
                                        @else
                                            <p class="text-danger">Not Paid</p>
                                        @endif
                                    </td>
                                    
                                    <td>
                                        <form action="{{ route('admin.update-product-status', $item->id) }}" class="d-flex" method="POST">
                                            @csrf
                                            <select name="status" id="" class="form-control mx-1" style="width: fit-content">
                                                <option value="Approved" {{ $item->status == 'Approved' ? "selected" : "" }}>Approved</option>
                                                <option value="Unapproved" {{ $item->status == 'Unapproved' ? "selected" : "" }}>Unapproved</option>
                                                <option value="Blocked" {{ $item->status == 'Blocked' ? "selected" : "" }}>Blocked</option>
                                            </select>
                                            <input type="submit" name="" value="Update" class="form-control btn btn-primary">
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                                @if ($products->count() === 0)
                                <tr>
                                    <td colspan="9">
                                        <p class="text-center">No Products</p>
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $products->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>
            </div>
        </div>    
    </div>
@endsection



