@extends('layouts.admin')
@section('content')
<div class="container">
<div class="d-flex justify-content-between align-items-center mb-4 pt-5">
    <h4>Edit Membership</h4>
    <a href="{{ route('admin.membership') }}" class="btn btn-primary">back</a>
</div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('membership.update' , $membership->id) }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="name">Name</label>
            <select name="name" id="name" class="form-control">
                <option value="">Select One</option>
                <option value="Standard" {{ $membership->name == 'Standard' ? 'selected' : '' }}>Standard</option>
                <option value="Premium" {{ $membership->name == 'Premium' ? 'selected' : '' }}>Premium</option>
            </select>
        </div>
        

        <div class="form-group">
            <label for="ad_limit">ad limit</label>
            <input type="number" name="ad_limit" value="{{ $membership->ad_limit }}" id="ad_limit" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="price">Price</label>
            <input type="number" step="0.01" name="price" value="{{ $membership->price }}" id="price" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="image_limit">image limit</label>
            <input type="number" name="image_limit" id="image_limit" value="{{ $membership->image_limit }}" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="ad_limit">Duration (Days)</label>
            <input type="number" name="duration_days" id="ad_limit" value="{{ $membership->duration_days }}" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-success">Update Membership</button>
    </form>
</div>
@endsection
