@extends('layouts.admin')
@section('content')

<div class="container">
<div class="d-flex justify-content-between align-items-center mb-4 pt-4">
    <h4>MemberShip</h4>
    <a href="{{ route('admin.add-membership') }}" class="btn btn-primary mb-3">Add New MemberShip Plan</a>
</div>
<form method="GET" action="{{ route('admin.membership') }}">
    <div class="input-group mb-3">
        <input 
            type="text" 
            name="search" 
            class="form-control" 
            placeholder="Search by title" 
            value="{{ request('search') }}">
        <button class="btn btn-primary" type="submit">Search</button>

        <a href="{{ route('admin.membership') }}" class="btn btn-secondary">Reset</a>
    </div>
</form>


    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Ad Limit</th>
                <th>Image Limit</th>
                <th>Duration (Days)</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @php
                $i = 0;
            @endphp
            @forelse ($plans as $plan)
            <tr>
                <td>{{ ++$i }}</td>
                <td>{{ $plan->name }}</td>
                <td>${{ number_format($plan->price, 2) }}</td>
                <td>{{ $plan->image_limit}}</td>
                <td>{{ $plan->duration_days }}</td>
                <td>
                    <a href="{{ route('membership.edit', $plan->id) }}">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAThJREFUSEvl1b1KxEAUhuFnK7HSSgTBQgQt9AYsrO28A6/AUlErFWT97fQWbLW1F7wBsRNBEMRC0M5K3QNZiMlmmUS38kBIQma+d853zmRaBhytAev7S8AxXnCSX3QRsIwDzPbJ7BMrOM+NOcVq9r6ehxQBT5ioKT6GW8S9G1vZQksWfWUjUq0bxRumcY3xbP4GjuK5KFQHsIa4FjqWPWAKN9jDWTeVpoBN7Gciz1jEPUbw3q/IKRmEv+1CnQIyj9di/epmEJZEOxYjWjO6pxR1AKniS7iqW4MdbCesPMQvMVwHEMIBSLHlo1P8oXx3pljULXweUOV5qUmaACKb3Yrd/mvAj/9MD0gjQJ9fU+nTPwA8YrKOJz3G3mGuah/EgXOImYaQOBeiyy6qAA11q6elHiyNwQMHfAOdL0QZH51cjgAAAABJRU5ErkJggg=="/>
                    </a>
                    <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="{{ $plan->id }}">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                    </button>
                </td>
            </tr>
            @empty
            <td class="text-center text-capitalize" colspan="8">no membership found</td>
        @endforelse
        </tbody>
    </table>
    {!! $plans->withQueryString()->links('pagination::bootstrap-5') !!}
</div>


{{-- delete modal --}}
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this membership?
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteModal = document.getElementById('deleteModal');
        const deleteForm = document.getElementById('deleteForm');

        deleteModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const id = button.getAttribute('data-id');
            deleteForm.action = `/delete-membership/${id}`;
        });
    });
</script>

@endsection
