@extends('layouts.admin')
@section('content')
<div class="container">
<div class="d-flex justify-content-between align-items-center mb-4 pt-5">
    <h4>Add MemberShip</h4>
    <a href="{{ route('admin.membership') }}" class="btn btn-primary">back</a>
</div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('membership.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="name">Name</label>
            <input type="text" name="name" id="name" class="form-control" required>
               
        </div>

        <div class="form-group">
            <label for="ad_limit">ad limit</label>
            <input type="number" name="ad_limit" id="ad_limit" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="price">Price</label>
            <input type="number" step="0.01" name="price" id="price" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="image_limit">image limit</label>
            <input type="number" name="image_limit" id="image_limit" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="ad_limit">Duration (Days)</label>
            <input type="number" name="duration_days" id="ad_limit" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-success mt-3">Create MemberShip</button>
    </form>
</div>
@endsection
