@extends('layouts.admin')

@section('content')
    <style>
        th, td {
            border: 1px solid #ddd;
            text-align: center;
            vertical-align: middle;
            padding: 10px;
        }
    </style>

    <div class="ps-section__content">
        <div class="row justify-content-center">
            <div class="card col-lg-11 mt-3 p-3">
                <h3>Payment Gateways</h3>

                {{-- Flash Messages --}}
                @if(session('success'))
                    <p class="col-12 alert alert-success">{{ session('success') }}</p>
                @endif

                @if(session('error'))
                    <p class="col-12 alert alert-danger">{{ session('error') }}</p>
                @endif

                <div class="col-12 mt-3">
                    <div class="row">
                        @foreach ($payments as $payment)
                            <div class="col-md-4 card border p-3 mx-2">
                                <form action="{{ route('switch-payment') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="payment_method" value="{{ $payment->payment_method }}">
                                    
                                    <div class="form-check form-switch mx-2 mb-3" style="width: fit-content">
                                        <input type="checkbox"
                                               class="form-check-input"
                                               name="status"
                                               value="1"
                                               id="switch-{{ $payment->payment_method }}"
                                               {{ $payment->status === 'disabled' ? '' : 'checked' }}>
                                        <label class="form-check-label"
                                               for="switch-{{ $payment->payment_method }}">
                                            {{ ucfirst($payment->payment_method) }} Payment
                                        </label>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Update</button>
                                </form>
                            </div>
                        @endforeach
                    </div>

                    <form action="{{ route('admin.cleanup') }}" method="GET" class="mt-4">
                        <button type="submit" class="btn btn-danger">Archive Old Records</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
