@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Messages</h3>
                    
                    <form method="GET" action="{{ route('admin.seller_messages') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.seller_messages') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    @foreach ($messages as $message)
                        
                        <a href="{{route('admin.seller-messages',$message->id)}}" class="text-decoration-none text-black">
                            <div class="w-100 mb-3">
                                <div class="d-flex bg-secondary-subtle rounded shadow p-2">
                                    <div  class="text-center align-content-center mx-2" style="width: fit-content">
                                        <img src="{{asset('storage/avatars/'.$message->profile->profile_picture)}}" alt="" style="width: 70px;height: 70px;border-radius: 50px;object-fit: cover;border:1px solid black">
                                    </div>
                                    <div  class="mx-3 w-100">
                                        <h5>{{$message->name}}</h5>
                                        <p class="p-0 m-0">
                                            {{$message->message[0]->message}}
                                        </p>
                                        <p class="text-end p-0 m-0">
                                            <i>{{$message->created_at->format('d-M-Y h:i:s A')}}</i>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    
                    @endforeach
                    @if ($messages->count() === 0 )
                        <p class="text-center">No Message Sent...!</p>
                    @endif
                     {!! $messages->links('pagination::bootstrap-5') !!}
                </div>
               
            </div>
        </div>    
    </div>
@endsection