@extends('layouts.admin')

@section('content')
<h2>Premium Membership Settings</h2>

<table class="table">
    <thead>
        <tr>
            <th>Seller</th>
            <th>Premium Status</th>
            <th>Price</th>
            <th>Duration (Days)</th>
            <th>Expiry</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($sellers as $seller)
        <tr>
            <form action="{{ route('admin.memberships.update') }}" method="POST">
                @csrf
                <input type="hidden" name="user_id" value="{{ $seller->id }}">
                <td>{{ $seller->name }}</td>
                <td>
                    <input type="checkbox" name="is_premium" {{ $seller->isPremiumSeller() ? 'checked' : '' }}>
                </td>
                <td>
                    <input type="number" name="membership_price" value="{{ $seller->membership_price }}" class="form-control">
                </td>
                <td>
                    <input type="number" name="membership_duration" value="{{ $seller->membership_duration }}" class="form-control">
                </td>
                <td>{{ $seller->membership_expires_at }}</td>
                <td>
                    <button type="submit" class="btn btn-primary">Update</button>
                </td>
            </form>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
