@extends('layouts.admin')

@section('content')
    <style>
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

        .premium-border {
            border: 2px solid gold;
            box-shadow: 0px 0px 10px gold;
        }
    </style>
    
    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center pt-3">
                <div class="col-lg-11 card p-4">
                    <h3>Media & Files</h3>
                    <form method="GET" action="{{ route('admin.seller_profiles') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Seller name</th>
                                    <th>Image</th>
                                    <th>file path</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($mediaLinks as $item)
                                    <tr class="align-content-center">
                                        <td>{{ ++$i }}</td>
                                        <td>{{ $item->seller->name }}</td>
                            
                                        {{-- File Type Check --}}
                                        <td>
                                            @php
                                                $extension = pathinfo($item->file_path, PATHINFO_EXTENSION);
                                            @endphp
                            
                                            @if(in_array($extension, ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                                                <img src="{{ asset('storage/' . $item->file_path) }}" alt="Image" width="50">
                                            @elseif(in_array($extension, ['mp4', 'avi', 'mov', 'wmv', 'mkv']))
                                                <video width="100" controls>
                                                    <source src="{{ asset('storage/' . $item->file_path) }}" type="video/{{ $extension }}">
                                                    Your browser does not support the video tag.
                                                </video>
                                            @else
                                                <p>Unsupported File</p>
                                            @endif
                                        </td>
                            
                                        <td><a href="{{ asset('storage/' . $item->file_path) }}" target="_blank">{{ $item->file_path }}</a></td>
                                    </tr>
                                @endforeach
                            
                                @if ($mediaLinks->count() === 0)
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Media Found</p>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                            
                            
                        </table>
                    </div>
                    {{-- {!! $mediaLinks->withQueryString()->links('pagination::bootstrap-5') !!}   --}}
                </div>
            </div>
        </div>    
    </div>


   <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this item?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <a href="" id="deleteSeller">
                    <button type="submit" class="btn btn-danger">Delete</button>
                </a>
            </div>
        </div>
    </div>
</div>



    <!-- Modal -->
    <div class="modal fade" id="userDetailsModal" tabindex="-1" aria-labelledby="userDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="userDetailsModalLabel">User Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <img src="" alt="" id="modalImage" style="width: 70px;height:70px;border-radius:50px">
                    <p><strong>Name:</strong> <span id="modalUserName"></span></p>
                    <p><strong>Email:</strong> <span id="modalUserEmail"></span></p>
                    <p><strong>Age:</strong> <span id="modalAge"></span></p>
                    <p><strong>Figure:</strong> <span id="modalFigure"></span></p>
                    <p><strong>Type:</strong> <span id="modalType"></span></p>
                    <p><strong>Eye Color:</strong> <span id="modalEyeColor"></span></p>
                    <p><strong>Hair Color:</strong> <span id="modalHairColor"></span></p>
                    <p><strong>Address:</strong> <span id="modalAddress"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const modal = new bootstrap.Modal(document.getElementById('userDetailsModal'));

            document.querySelectorAll('.view-details-btn').forEach(button => {
                button.addEventListener('click', () => {
                    // Get user details from data attributes
                    const userImage = button.getAttribute('data-image');
                    const userName = button.getAttribute('data-name');
                    const userEmail = button.getAttribute('data-email');
                    const userAge = button.getAttribute('data-age');
                    const userType = button.getAttribute('data-type');
                    const userFigure = button.getAttribute('data-figure');
                    const userHairColor = button.getAttribute('data-hair_color');
                    const userEyeColor = button.getAttribute('data-eye_color');
                    const userAddress = button.getAttribute('data-address');

                    // Populate modal fields
                    // document.getElementById('modalImage').textContent = userImage;
                    document.getElementById('modalUserName').textContent = userName;
                    document.getElementById('modalUserEmail').textContent = userEmail;

                    document.getElementById('modalAge').textContent = userAge;
                    document.getElementById('modalFigure').textContent = userFigure;
                    document.getElementById('modalType').textContent = userType;
                    document.getElementById('modalEyeColor').textContent = userEyeColor;
                    document.getElementById('modalHairColor').textContent = userHairColor;
                    document.getElementById('modalAddress').textContent = userAddress;

                    document.getElementById('modalImage').src = `{{ asset('storage/avatars') }}/${userImage}`;


                    // const filesContainer = document.getElementById('modalUserFiles');
                    // filesContainer.innerHTML = '';
                    // userFiles.forEach(file => {
                    //     if (file) {
                    //         const filePath = `{{ asset('storage') }}/${file.trim()}`;
                    //         const fileElement = file.endsWith('.mp4') ?
                    //             `<video controls width="100%"><source src="${filePath}" type="video/mp4"></video>` :
                    //             `<img src="${filePath}" alt="File Image" style="max-width: 100%; margin-bottom: 10px;">`;
                    //         filesContainer.innerHTML += fileElement;
                    //     }
                    // });

                    // Show modal
                    modal.show();
                });
            });
        });
    </script>

 
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteModal = document.getElementById('deleteModal');
        const deleteForm = document.getElementById('deleteForm');
        
        deleteModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget; // Button that triggered the modal
            const id = button.getAttribute('data-id'); // Extract ID from data-* attribute
            // Update the form's action attribute
            // const action = deleteForm.getAttribute('action').replace('0', id);
            // deleteForm.setAttribute('action', action);
            document.getElementById('deleteSeller').href = id;
        });
    });
</script>


@endsection