@extends('layouts.admin')

@section('content')
    <style>
        th, td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }
    </style>

    <div>
        <!-- Unapproved Lovecans Ads -->
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>Unapproved Lovecan Women</h3>
                    <form method="GET" action="{{ route('admin.lovecanwomen') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}"/>
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.lovecanwomen') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Description</th>
                                    <th>Worn Days</th>
                                    <th>Price</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $i = 0; @endphp
                                @foreach ($unapprovedAds as $ad)
                                <tr>
                                    <td>{{ ++$i }}</td>
                                    <td><img src="{{ asset('storage/ads/'.$ad->image) }}" alt="Ad Image" style="width: 50px;"></td>
                                    <td>{{ $ad->title }}</td>
                                    <td>{{ $ad->type }}</td>
                                    <td>{{ $ad->description }}</td>
                                    <td>{{ $ad->worn_days }}</td>
                                    <td>${{ $ad->price }}</td>
                                    <td><span class="badge bg-warning">Pending</span></td>
                                    <td>
                                        <a href="{{ route('admin.lovecans.approve', $ad->id) }}" class="btn btn-success btn-sm">Approve</a>
                                    </td>
                                </tr>
                                @endforeach
                                @if ($unapprovedAds->count() === 0)
                                    <tr>
                                        <td colspan="9">
                                            <p class="text-center">No Pending Products</p>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        {!! $unapprovedAds->links() !!}
                    </div>
                </div>
            </div>
        </div>

        <!-- Approved Lovecans Ads -->
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>Approved Lovecan Women</h3>
                    <form method="GET" action="{{ route('admin.lovecanwomen') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}"/>
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.lovecanwomen') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Description</th>
                                    <th>Worn Days</th>
                                    <th>Price</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $i = 0; @endphp
                                @foreach ($approvedAds as $ad)
                                <tr>
                                    <td>{{ ++$i }}</td>
                                    <td><img src="{{ asset('storage/ads/'.$ad->image) }}" alt="Ad Image" style="width: 50px;"></td>
                                    <td>{{ $ad->title }}</td>
                                    <td>{{ $ad->type }}</td>
                                    <td>{{ $ad->description }}</td>
                                    <td>{{ $ad->worn_days }}</td>
                                    <td>${{ $ad->price }}</td>
                                    <td><span class="badge bg-success">Approved</span></td>
                                    <td><button class="btn btn-secondary btn-sm" disabled>Approved</button></td>
                                </tr>
                                @endforeach
                                @if ($approvedAds->count() === 0)
                                    <tr>
                                        <td colspan="9">
                                            <p class="text-center">No Approved Products</p>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        {!! $approvedAds->links() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
