@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center pt-3">
                <div class="col-lg-11 card p-4">
                    <h3>Locked Seller</h3>
                    <form method="GET" action="{{ route('admin.locked_sellers') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
<a href="{{ route('admin.locked_sellers') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Profile</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Age</th>
                                    <th>type</th>
                                    {{-- <th>Figure</th>
                                    <th>Hair Color</th>
                                    <th>Eye Color</th>
                                    <th>Address</th> --}}
                                    <th>Action</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($data as $item)
                                
                                @if ($item->profile != null)
                                <tr class="align-content-center">
                                    <td>{{++$i}}</td>
                                    <td>
                                        <img src="{{asset('storage/avatars/'.$item->profile->profile_picture)}}" alt="" style="width: 50px;border-radius:50px">
                                    </td>
                                    <td>{{$item->name}}</td>
                                    <td>{{$item->email}}</td>
                                    <td>{{$item->profile->age}}</td>
                                    <td>{{$item->profile->type}}</td>
                                    {{-- <td>{{$item->figure}}</td>
                                    <td>{{$item->hair_color}}</td>
                                    <td>{{$item->eye_color}}</td>
                                    <td>{{$item->address}}</td> --}}
                                    <td>
                                        {{-- <form action="" method="POST" class="d-flex">
                                            @csrf
                                            <input type="submit" class="form-control btn btn-primary" value="View Details">
                                        </form> --}}
                                        <a href="{{route('admin.edit_seller',$item->profile->id)}}">
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAThJREFUSEvl1b1KxEAUhuFnK7HSSgTBQgQt9AYsrO28A6/AUlErFWT97fQWbLW1F7wBsRNBEMRC0M5K3QNZiMlmmUS38kBIQma+d853zmRaBhytAev7S8AxXnCSX3QRsIwDzPbJ7BMrOM+NOcVq9r6ehxQBT5ioKT6GW8S9G1vZQksWfWUjUq0bxRumcY3xbP4GjuK5KFQHsIa4FjqWPWAKN9jDWTeVpoBN7Gciz1jEPUbw3q/IKRmEv+1CnQIyj9di/epmEJZEOxYjWjO6pxR1AKniS7iqW4MdbCesPMQvMVwHEMIBSLHlo1P8oXx3pljULXweUOV5qUmaACKb3Yrd/mvAj/9MD0gjQJ9fU+nTPwA8YrKOJz3G3mGuah/EgXOImYaQOBeiyy6qAA11q6elHiyNwQMHfAOdL0QZH51cjgAAAABJRU5ErkJggg=="/>
                                        </a>
                                        <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="{{route('admin.delete-seller',$item->id)}}">
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                                        </button>
                                        {{-- <button class="btn btn-primary view-details-btn" 
                                            data-image="{{ $item->profile_picture }}"
                                            data-name="{{ $item->name }}"
                                            data-email="{{ $item->email }}"
                                            data-age="{{ $item->age }}"
                                            data-type="{{ $item->type }}"
                                            data-figure="{{ $item->figure }}"
                                            data-hair_color="{{ $item->hair_color }}"
                                            data-eye_color="{{ $item->eye_color }}"
                                            data-address="{{ $item->address }}">
                                            View Details
                                        </button> --}}
                                    </td>
                                    <td>
                                        <form action="{{route('admin.update-seller-status',$item->profile->id)}}" method="POST" class="d-flex">
                                            @csrf
                                            <select name="status" id="" class="form-control mx-1" style="width: fit-content">
                                                <option value="pending"   {{$item->profile->status == 'pending' ? 'selected' : ''}}>Pending</option>
                                                <option value="verified"   {{$item->profile->status == 'verified' ? 'selected' : ''}}>Verified</option>
                                                <option value="blocked"   {{$item->profile->status == 'blocked' ? 'selected' : ''}}>Blocked</option>
                                            </select>
                                            <input type="submit" class="form-control btn btn-primary" value="Update">
                                        </form>
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @if ($data->count() == 0 )
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Locked Sellers</p>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $data->withQueryString()->links('pagination::bootstrap-5') !!}  
                </div>
            </div>
        </div>    
    </div>


    <!-- Modal -->
    <div class="modal fade" id="userDetailsModal" tabindex="-1" aria-labelledby="userDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="userDetailsModalLabel">User Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <img src="" alt="" id="modalImage" style="width: 70px;height:70px;border-radius:50px">
                    <p><strong>Name:</strong> <span id="modalUserName"></span></p>
                    <p><strong>Email:</strong> <span id="modalUserEmail"></span></p>
                    <p><strong>Age:</strong> <span id="modalAge"></span></p>
                    <p><strong>Figure:</strong> <span id="modalFigure"></span></p>
                    <p><strong>Type:</strong> <span id="modalType"></span></p>
                    <p><strong>Eye Color:</strong> <span id="modalEyeColor"></span></p>
                    <p><strong>Hair Color:</strong> <span id="modalHairColor"></span></p>
                    <p><strong>Address:</strong> <span id="modalAddress"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const modal = new bootstrap.Modal(document.getElementById('userDetailsModal'));

            document.querySelectorAll('.view-details-btn').forEach(button => {
                button.addEventListener('click', () => {
                    // Get user details from data attributes
                    const userImage = button.getAttribute('data-image');
                    const userName = button.getAttribute('data-name');
                    const userEmail = button.getAttribute('data-email');
                    const userAge = button.getAttribute('data-age');
                    const userType = button.getAttribute('data-type');
                    const userFigure = button.getAttribute('data-figure');
                    const userHairColor = button.getAttribute('data-hair_color');
                    const userEyeColor = button.getAttribute('data-eye_color');
                    const userAddress = button.getAttribute('data-address');

                    // Populate modal fields
                    // document.getElementById('modalImage').textContent = userImage;
                    document.getElementById('modalUserName').textContent = userName;
                    document.getElementById('modalUserEmail').textContent = userEmail;

                    document.getElementById('modalAge').textContent = userAge;
                    document.getElementById('modalFigure').textContent = userFigure;
                    document.getElementById('modalType').textContent = userType;
                    document.getElementById('modalEyeColor').textContent = userEyeColor;
                    document.getElementById('modalHairColor').textContent = userHairColor;
                    document.getElementById('modalAddress').textContent = userAddress;

                    document.getElementById('modalImage').src = `{{ asset('storage/avatars') }}/${userImage}`;


                    // const filesContainer = document.getElementById('modalUserFiles');
                    // filesContainer.innerHTML = '';
                    // userFiles.forEach(file => {
                    //     if (file) {
                    //         const filePath = `{{ asset('storage') }}/${file.trim()}`;
                    //         const fileElement = file.endsWith('.mp4') ?
                    //             `<video controls width="100%"><source src="${filePath}" type="video/mp4"></video>` :
                    //             `<img src="${filePath}" alt="File Image" style="max-width: 100%; margin-bottom: 10px;">`;
                    //         filesContainer.innerHTML += fileElement;
                    //     }
                    // });

                    // Show modal
                    modal.show();
                });
            });
        });
    </script>


@endsection