@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center pt-3">
                <div class="col-lg-11 card p-4">
                    <h3>Seller Gender Messages</h3>
                    <form method="GET" action="{{ route('admin.gendermessages') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.gendermessages') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        @if($sellers->isEmpty())
                        <div class="alert alert-warning text-center">No record found matching your search criteria.</div>
                        @else
                        <table class="table table-bordered text-center">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Seller Name</th>
                                    <th>Email</th>
                                    <th>Current Gender</th>
                                    <th>Last Message</th>
                                    <th>Update Gender</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($sellers as $seller)
                                <tr>
                                    <td>{{ $seller->id }}</td>
                                    <td>{{ $seller->name }}</td>
                                    <td>{{ $seller->email }}</td>
                                    <td>{{ ucfirst($seller->profile->gender) }}</td>
                                    <td>
                                        @if($seller->adminMessages->count() > 0)
                                            {{ $seller->adminMessages->last()->message }}
                                        @else
                                        No Messages
                                        @endif
                                    </td>
                                    <td>
                                        <form action="{{ route('admin.update.seller.gender', $seller->id) }}" method="POST">
                                        @csrf
                                        <select class="form-control" name="gender">
                                        <option value="male" {{ $seller->profile->gender == 'male' ? 'selected' : '' }}>Male</option>
                                        <option value="female" {{ $seller->profile->gender == 'female' ? 'selected' : '' }}>Female</option>
                                        </select>
                                    </td>
                                    <td>
                                    <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                    </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @endif
                    </div>
                    {!! $sellers->withQueryString()->links('pagination::bootstrap-5') !!}  
                </div>
            </div>
        </div>    
    </div>

@endsection

