@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 card m-3">
            <form action="{{route('admin.update_seller')}}" method="POST" class="row justify-content-center">
                @csrf
                 @foreach ($data as $item)
                    
                @endforeach
                <input type="hidden" name="user_id" value="{{$item->user_id}}">
                <input type="hidden" name="profile_id" value="{{$item->profile_id}}">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">
                        Seller Details 
                    </h1>
                    <a href="{{ route('admin.seller_profiles') }}" class="btn btn-primary">back</a>
                </div>
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Name</label>
                    <input type="text" name="name" value="{{$item->name}}" class="form-control">
                    @error('name')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Nickname</label>
                    <input type="text" name="nickname" value="{{$item->nickname}}" class="form-control">
                    @error('nickname')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3  form-group">
                    <label for="">Description</label>
                    <input type="text" name="description" value="{{$item->description}}" class="form-control">
                    @error('description')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Email</label>
                    <input type="text" name="email" value="{{$item->email}}" class="form-control">
                    @error('email')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Age</label>
                    <input type="number"  name="age" value="{{$item->age}}" class="form-control">
                    @error('age')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Figure</label>
                    <select class="form-control" name="figure">
                        <option value="Athletic" {{($item->figure=='Athletic'?"selected":"")}}>Athletic</option>
                        <option value="Normal" {{($item->figure=='Normal'?"selected":"")}}>Normal</option>
                        <option value="Slim" {{($item->figure=='Slim'?"selected":"")}}>Slim</option>
                        <option value="Chubby" {{($item->figure=='Chubby'?"selected":"")}}>Scandinavian</option>
                        <option value="Fat" {{($item->figure=='Fat'?"selected":"")}}>Fat</option>
                    </select>
                    @error('figure')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Type</label>
                    <select class="form-control" name="type">
                        <option value="German"  {{($item->type=='German'?"selected":"")}}>German</option>
                        <option value="Western European"  {{($item->type=='Western European'?"selected":"")}}>Western European</option>
                        <option value="European"  {{($item->type=='European'?"selected":"")}}>European</option>
                        <option value="Scandinavian"  {{($item->type=='Scandinavian'?"selected":"")}}>Scandinavian</option>
                        <option value="Eastern European"  {{($item->type=='Eastern European'?"selected":"")}}>Eastern European</option>
                        <option value="Southern European"  {{($item->type=='Southern European'?"selected":"")}}>Southern European</option>
                        <option value="Asian"  {{($item->type=='Asian'?"selected":"")}}>Asian</option>
                        <option value="South and Latin American"  {{($item->type=='South and Latin American'?"selected":"")}}>South and Latin American</option>
                        <option value="Oriental"  {{($item->type=='Oriental'?"selected":"")}}>Oriental</option>
                        <option value="African American"  {{($item->type=='African American'?"selected":"")}}>African American</option>
                        <option value="Exotic"  {{($item->type=='Exotic'?"selected":"")}}>Exotic</option>
                    </select>
                    @error('type')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Eye color</label>
                    <select class="form-control" name="eye_color">
                        <option value="Blue" {{($item->eye_color=='Blue'?"selected":"")}}>Blue</option>
                        <option value="Brown" {{($item->eye_color=='Brown'?"selected":"")}}>Brown</option>
                        <option value="Green" {{($item->eye_color=='Green'?"selected":"")}}>Green</option>
                        <option value="Grey" {{($item->eye_color=='Grey'?"selected":"")}}>Grey</option>
                    </select>
                    @error('eye_color')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label>Hair Color</label>
                    <select class="form-control" name="hair_color">
                        <option value="Blonde" {{($item->hair_color=='Blonde'?"selected":"")}}>Blonde</option>
                        <option value="Brunette" {{($item->hair_color=='Brunette'?"selected":"")}}>Brunette</option>
                        <option value="Black" {{($item->hair_color=='Black'?"selected":"")}}>Black</option>
                        <option value="Red" {{($item->hair_color=='Red'?"selected":"")}}>Red</option>
                    </select>
                    @error('hair_color')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Address</label>
                    <input type="text" name="address" value="{{$item->address}}" class="form-control">
                    @error('address')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Password</label>
                    <input type="password" name="password" placeholder="Enter New Password" class="form-control">
                    @error('password')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                
                <div class="col-md-6 mb-3 form-group">
                    <label for="">Confirm Password</label>
                    <input type="password" name="password_confirmation" placeholder="Confirm Password" class="form-control">
                    @error('password_confirmation')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-12 mb-3 d-flex form-group justify-content-end">
                    <input type="submit" class="form-control btn btn-primary" value="Update" style="width: 20%">
                </div>
            </form>
        </div>    
    </div>


@endsection