@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 card m-3">
            <form action="{{ route('admin.update-category', $category->id) }}" method="POST" class="row justify-content-center" enctype="multipart/form-data">
                @csrf

                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">
                        Edit Category
                    </h1>
                    <a href="{{ route('admin.categories') }}" class="btn btn-primary">back</a>
                </div>
                <div class="my-3 form-group">
                    <label for="">Category</label>
                    <input type="text" name="category" value="{{$category->category}}" class="form-control">
                    @error('category')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-12 mb-2 form-group">
                    <label for="">Category Image</label>
                    <input type="file" name="image" class="form-control" name="image">
                    @if($category->image)
                        <!-- Display the current image if it exists -->
                        <div>
                            <img src="{{ asset('storage/' . $category->image) }}" alt="Category Image" class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                            <p>Current Image</p>
                        </div>
                    @endif

                    @error('image')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div class="col-12 mb-2 form-group">
                    <label for="">Category status</label>
                    <select name="status" class="form-control">
                        <option value="1" {{ $category->status == 1 ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ $category->status == 0 ? 'selected' : '' }}>InActive</option>
                    </select>
                    @error('status')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div class="col-md-12 mb-3 d-flex form-group justify-content-end">
                    <input type="submit" class="form-control btn btn-primary" value="Update" style="width: 20%">
                </div>
            </form>
        </div>    
    </div>


@endsection