@extends('layouts.admin')

@section('content')
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Customer Messages</h3>
                    
                    <form method="GET" action="{{ route('admin.customer-messages') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by name" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.customer-messages') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Full Name</th>
                                    <th>Email</th>
                                    <th>Subject</th>
                                    <th>Message</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($messages as $message)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $message->name }}</td>
                                        <td>{{ $message->email }}</td>
                                        <td>{{ $message->subject }}</td>
                                        <td>{{ $message->message }}</td>
                                        <td>{{ $message->created_at->format('d M Y h:i:s A') }}</td>
                                    </tr>
                                @endforeach
                                @if ($messages->count() === 0)
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Messages . . . !</p>
                                        </td>                                    
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                     {!! $messages->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>
               
            </div>
        </div>    
    </div>
@endsection