@extends('layouts.admin')

@section('content')
    <style>
        th, td {
            border: 1px solid #ddd;
            text-align: center; 
            vertical-align: middle; 
            padding: 10px;
        }
    </style>

    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Cans Inventory</h3>
                    
                    <form method="GET" action="{{ route('admin.cans') }}">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="{{ request('search') }}">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="{{ route('admin.cans') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>

                    <!-- Display Current Cans Inventory -->
                    <div class="alert alert-info">
                        <strong>Current Inventory:</strong> 
                        {{ $totalCans }} cans available.
                    </div>

                    <!-- Manage Cans Form -->
                    <form action="{{ route('admin.update-cans') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="quantity" class="form-label">Adjust Quantity:</label>
                            <input type="number" id="quantity" name="quantity" class="form-control" placeholder="Enter number of cans">
                        </div>

                        <div class="mb-3">
                            <label for="action" class="form-label">Action:</label>
                            <select name="action" id="action" class="form-control">
                                <option value="add">Add Cans</option>
                                <option value="remove">Remove Cans</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-success">Update Inventory</button>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Full Name</th>
                                    <th>No. Of Cans</th>
                                    <th>Payment Id</th>
                                    <th>Amount</th>
                                    <th>Source</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cans as $can)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $can->user->name }}</td>
                                        <td>{{ $can->cans }}</td>
                                        <td>{{ $can->payment_id }}</td>
                                        <td>{{ $can->amount. ' ' . $can->currency }}</td>
                                        <td>{{ $can->source }}</td>
                                        <td>{{ $can->created_at->format('d-m-Y h:i:s A') }}</td>
                                        <td>{{ $can->payment_status }}</td>
                                        <td>
                                            <form action="{{ route('cans.status-update', $can->id) }}" method="POST">
                                                @csrf
                                                <div class="row p-0">
                                                    <div class="col-6" style="min-width: fit-content">
                                                        <select name="status" class="form-control" style="width: fit-content">
                                                            <option value="Pending" {{ ($can->status == 'Pending') ? 'selected' : '' }}>Pending</option>
                                                            <option value="Approved" {{ ($can->status == 'Approved') ? 'selected' : '' }}>Approved</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-6" style="min-width: fit-content">
                                                        <input type="submit" value="Update" class="btn btn-primary w-100" {{ ($can->status == 'Approved') ? 'disabled' : '' }}>
                                                    </div>
                                                </div>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @if ($cans->count() === 0)
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Can Request . . . !</p>
                                        </td>                                    
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $cans->withQueryString()->links('pagination::bootstrap-5') !!}
                </div>
            </div>
        </div>    
    </div>
@endsection
