@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        <div class="ps-section__content p-4 m-3 row justify-content-center">
            @if(session('success'))
                <p class="alert alert-success" role="alert">
                    {{ session('success') }}
                </p>
            @endif

            @if(session('error'))
                <p class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </p>
            @endif

            <form action="{{ route('slider.update', $bannerslider->id) }}" method="POST" class="p-4 card row col-md-6 justify-content-center" enctype="multipart/form-data">
                @csrf

                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="lead">Edit Banner Slider</h1>
                    <a href="{{ route('slider.index') }}" class="btn btn-primary text-capitalize">back</a>
                  </div>

                <div class="col-12 mb-2  form-group">
                    <label for="">Images</label>

                    <input type="file" name="sliderimages"  class="form-control">
                    <img src="{{ asset('storage/' . $bannerslider->sliderimages) }}" alt="slider Image" class="img-fluid">

                    @error('sliderimages')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>

                <div class="col-md-12 mb-3 d-flex form-group justify-content-center">
                    <button class="btn btn-primary w-100">Update</button>
                </div>
            </form>
        </div>
    </div>
@endsection
