@extends('layouts.admin')

@section('content')
    <div class="pt-3">
        
        <div class="ps-section__content p-4  m-3 row justify-content-center">
            @session('success')
                <p class="alert alert-success" role="alert">
                    {{session('success')}}
                </p>
            @endsession

            @session('error')
                <p class="alert alert-danger" role="alert">
                    {{session('error')}}
                </p>
            @endsession
            <form action="{{route('admin.store_category')}}" method="POST" class="p-4 card row col-md-6 justify-content-center" enctype="multipart/form-data">
                @csrf
                <h1 class="lead">
                    Add New Category
                </h1>
                <div class="col-12 mb-2  form-group">
                    <label for="">Category Title</label>
                    <input type="text" name="category"  class="form-control" placeholder="Category Title ...">
                    @error('category')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-12 mb-2  form-group">
                    <label for="">Category Image</label>
                    <input type="file" name="image"  class="form-control" placeholder="image Title ...">
                    @error('image')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>

                <div class="col-12 mb-2  form-group">
                    <label for="">Category status</label>
                    <select name="status" id="" class="form-control">
                        <option value="1">Active</option>
                        <option value="0">InActive</option>
                    </select>
                    @error('status')
                        <p class="text-danger">
                            {{$message}}
                        </p>
                    @enderror
                </div>
                <div class="col-md-12 mb-3 d-flex form-group justify-content-end">
                    <input type="submit" class="form-control btn btn-primary" value="Add Category" style="width: 50%">
                </div>
            </form>
        </div>    
    </div>


@endsection