<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('media_purchases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_id');
            $table->unsignedBigInteger('media_id'); // Purchased media
            $table->enum('status', ['pending', 'paid', 'failed'])->default('pending');
            $table->string('name');
            $table->string('buyer_email');
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('seller_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('media_id')->references('id')->on('media_files')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('media_purchases');
    }
};
