<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('media_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_id');
            $table->text('file_path')->nullable(); // Snippet file path
            $table->text('external_link')->nullable(); // Full media link
            $table->decimal('price', 8, 2)->nullable();
            $table->enum('type', ['image', 'video', 'external_link']);
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('seller_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('media_files');
    }
};
