<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            // Check if 'user_id' column exists before adding it
            if (!Schema::hasColumn('payments', 'user_id')) {
                $table->unsignedBigInteger('user_id')->after('id');
            }

            // Change 'payment_status' column type to TEXT
            $table->text('payment_status')->change();
        });
    }

    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            // Rollback 'payment_status' column to string
            $table->string('payment_status')->change();

            // Drop 'user_id' column only if it was added by mistake
            // if (Schema::hasColumn('payments', 'user_id')) {
            //     $table->dropColumn('user_id');
            // }
        });
    }
};
