<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->after('id');
            $table->unsignedBigInteger('ad_id')->after('user_id');
            $table->decimal('amount', 10, 2)->after('payment_method');
            $table->enum('payment_status', ['pending', 'completed', 'failed'])->default('pending')->after('amount');
            $table->string('transaction_id')->nullable()->after('payment_status');

            // Foreign keys
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('ad_id')->references('id')->on('ads')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['ad_id']);
            $table->dropColumn(['user_id', 'ad_id', 'amount', 'payment_status', 'transaction_id']);
        });
    }
};
