<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->boolean('is_promoted')->default(0)->after('admin_approved');
            $table->timestamp('promotion_expiry')->nullable()->after('is_promoted');
            $table->integer('promotion_paid_amount')->default(0)->after('promotion_expiry');
        });
    }

    public function down()
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->dropColumn(['is_promoted', 'promotion_expiry', 'promotion_paid_amount']);
        });
    }
};
