<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::table('reports', function (Blueprint $table) {
        // Dropping the user_id column
        $table->dropColumn('user_id');
        
        // Adding the report_id column
        $table->unsignedBigInteger('report_id'); 
    });
}

public function down()
{
    Schema::table('reports', function (Blueprint $table) {
        // Dropping the report_id column and restoring the user_id column
        $table->dropColumn('report_id');
        
        // Restoring the user_id column
        $table->unsignedBigInteger('user_id'); 
    });
}
};
