<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::table('reports', function (Blueprint $table) {
        // Dropping the report_id column
        $table->dropColumn('report_id');
        
        // Adding the user_id column (foreign key reference to users table)
        $table->unsignedBigInteger('user_id')->nullable(); // nullable agar kuch reports ke liye user null ho

        // Adding foreign key constraint to user_id column (if users table exists)
        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
}

public function down()
{
    Schema::table('reports', function (Blueprint $table) {
        // Dropping the user_id column and restoring the report_id column
        $table->dropForeign(['user_id']);
        $table->dropColumn('user_id');
        
        // Restore the report_id column (if needed)
        $table->unsignedBigInteger('report_id'); 
    });
}
};
