<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('media_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_id'); // Seller ka ID
            $table->enum('type', ['image', 'video', 'external_link']); // Media type
            $table->string('file_path')->nullable(); // Agar file upload hui ho toh
            $table->string('external_link')->nullable(); // Agar external link ho toh
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('seller_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('media_files');
    }
};
