<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('profiles', function (Blueprint $table) {
            // Adding profile_type column
            $table->enum('profile_type', ['Standard', 'Premium'])->default('Standard');
    
            // Adding the ad and media limits
            $table->integer('max_ads')->default(5);  // Max 5 ads for Standard by default
            $table->integer('max_media_per_ad')->default(3);  // Max 3 media per ad for Standard
    
            // Optionally, add columns for custom font/emoji text styling
            $table->boolean('allow_custom_fonts')->default(false);
            $table->boolean('allow_emojis')->default(false);
            $table->boolean('allow_bold')->default(false);
            $table->boolean('allow_italic')->default(false);
            $table->boolean('allow_underline')->default(false);
        });
    }
    
    public function down()
    {
        Schema::table('profiles', function (Blueprint $table) {
            // Remove the columns if we need to rollback the migration
            $table->dropColumn('profile_type');
            $table->dropColumn('max_ads');
            $table->dropColumn('max_media_per_ad');
            $table->dropColumn('allow_custom_fonts');
            $table->dropColumn('allow_emojis');
            $table->dropColumn('allow_bold');
            $table->dropColumn('allow_italic');
            $table->dropColumn('allow_underline');
        });
    }
};
