<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('gender', ['male', 'female', 'other'])->default('female');
        });

        Schema::table('ads', function (Blueprint $table) {
            $table->boolean('is_lovecans')->default(false);
            $table->boolean('admin_approved')->default(false); // Admin Approval
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('gender');
        });

        Schema::table('ads', function (Blueprint $table) {
            $table->dropColumn(['is_lovecans', 'admin_approved']);
        });
    }

};
