<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_premium')->default(false); // Premium status
            $table->decimal('membership_price', 10, 2)->nullable(); // Price
            $table->integer('membership_duration')->nullable(); // Duration in days
            $table->timestamp('membership_expires_at')->nullable(); // Expiry Date
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['is_premium', 'membership_price', 'membership_duration', 'membership_expires_at']);
        });
    }
};
