<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->boolean('paused')->default(0); // Add 'paused' field (0 = active, 1 = paused)
        });
    }
    
    public function down(): void
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->dropColumn('paused'); // Rollback the addition of the 'paused' field
        });
    }
};
