<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Plan name (e.g., Basic, Premium)
            $table->string('stripe_price_id'); // Stripe price ID
            $table->decimal('price', 8, 2); // Adjustable price
            $table->integer('duration_days')->default(30); // Duration in days
            $table->integer('max_ads')->default(5); // Max ads
            $table->integer('max_media')->default(3); // Max images/videos per ad
            $table->boolean('is_premium')->default(false); // Is it a premium plan?
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
