<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('additional_refinements', function (Blueprint $table) {
            $table->id();
            $table->string('refinement_title');
            $table->foreignIdFor(App\Models\Ad::class)->constrained()->cascadeOnDelete();
            $table->string('refinement_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('additional_refinements');
    }
};
