<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sellerads', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(App\Models\User::class)->constrained()->cascadeOnDelete();
            $table->string('title');
            $table->string('type');
            $table->string('image');
            $table->string('description');
            $table->integer('quantity');
            $table->integer('worn_days');
            $table->integer('price');
            $table->boolean('free_of_diseases')->default(false);
            $table->boolean('drugs_free')->default(false); 
            $table->string('tracking_link')->nullable(); 
            $table->boolean('is_received')->default(false); 
            $table->boolean('payment_status')->default(false); 
            $table->string('offer_status')->default('Unapproved');
            $table->string('offer_sent_status')->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sellerads');
    }
};
