<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(App\Models\User::class)->constrained()->cascadeOnDelete();
            $table->string('gender');
            $table->integer('age');
            $table->enum('clothing_size',['xs','s','m','l','xl','xxl','xxxl']);
            $table->string('type');
            $table->string('figure');
            $table->string('hair_color');
            $table->string('eye_color');
            $table->string('nickname');
            $table->string('profile_picture')->nullable();
            $table->string('address');
            $table->string('instagram')->nullable();
            $table->string('onlyfans')->nullable();
            $table->string('snapchat')->nullable();
            $table->string('description');
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
