<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(App\Models\User::class)->constrained()->cascadeOnDelete();
            $table->string('title');
            $table->string('type');
            $table->string('image');
            $table->json('gallery')->nullable();
            $table->string('description');
            $table->integer('worn_days');
            $table->integer('price');
            $table->boolean('free_of_diseases');
            $table->boolean('drugs_free'); 
            $table->string('status')->default('Unapproved');
            $table->enum ('ad_status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads');
    }
};
