<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Ad>
 */
class AdFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */

    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'name' => fake()->word,
            'type' => fake()->randomElement(['thong', 'brief', 'sock']),
            'price' => fake()->randomFloat(2, 10, 100),
            'worn_days' => fake()->numberBetween(1, 7),
            'approved' => false,
        ];
    }
}
