<?php

namespace App\Services;

use Twilio\Rest\Client;
use Illuminate\Support\Facades\Log;

class TwilioService
{
    protected $client;

    public function __construct()
    {
        $sid = env('TWILIO_SID','ACe4088baaeeed0147b2a18c8303d2929a');
        $token = env('TWILIO_AUTH_TOKEN','b46b2887d1bb31ec3bd0ad2f205d8305');

        if (!$sid || !$token) {
            throw new \Exception("Twilio API credentials are missing in .env file.");
        }

        $this->client = new Client($sid, $token);
    }

    public function sendSms($to, $message)
    {
        try {
            $from = env('TWILIO_PHONE_NUMBER','+14787074416');

            if (!$from) {
                throw new \Exception("Twilio phone number is missing in .env file.");
            }

            $this->client->messages->create($to, [
                'from' => $from,
                'body' => $message
            ]);

            Log::info("OTP sent successfully to {$to}");
        } catch (\Exception $e) {
            Log::error("Twilio SMS sending failed: " . $e->getMessage());
        }
    }
}
